%% Generating a Barabasi-Albert network
%Get things started
nodes=1000; %size of network
A = zeros(nodes); %initially empty adjacency matrix
degree_vector=zeros(1,nodes); %This vector will store the degree of each node
edges=0; %store the total number of edges in the graph

A(1,2)=1;
A(2,1)=1;%make first connection
degree_vector(1)=1; %update degree vector
degree_vector(2)=1;
edges=1; %update edge count

H = graph(A(1:nodes,1:nodes));
plot(H,'Layout','force')
set(gca, 'FontSize', 1);

%% Now loop over remaining nodes
for i=3:nodes
    %connect the ith node.
    %I need to connect to node j with a probability proportional to its entry in the
    %degree vector. The sum of the degree vector is 2*edges. Therefore I
    %generate a random number between 0 and 2*edges, and work through the
    %nodes, summing degree_vector, until my sum exceed the random number. I
    %connect to the node at which I stop. This method is identical to
    %choosing the destination state in a discrete-state Markov chain
    
    test = 2*edges*rand; %random # between 0 and sum of degrees  
    tally=0;
    for j=1:i-1
        tally=tally+degree_vector(j);
        if(tally>test)
            A(i,j)=1; %make the connection and update
            A(j,i)=1;
            degree_vector(i)=1;
            degree_vector(j)=degree_vector(j)+1;
            edges=edges+1;
            break;
        end
    end
end

H = graph(A(1:nodes,1:nodes));
plot(H,'Layout','force')
set(gca, 'FontSize', 1);
%% 